package automobile;

/**
 * Gestion de l'erreur jetée par le Véhicule en cas de capacité dépassée lors de mise de carburant
 * Si on dépasse la capacité fixée à 50L, on affiche une erreur
 * @author Adrien Poupa
 */
public class CapaciteDepasseeException extends Exception {
    private int litres;

    /**
     * Instanciation de l'erreur
     * @param litres Nombre de litres à rajouter
     */
    public CapaciteDepasseeException(int litres) {
        this.litres = litres;
    }

    /**
     * Affichage de l'erreur avec le nombre de litres qu'on a essayé de rajouter
     * @return message "Votre réservoir a une capacité insuffisante pour mettre XL d'essence"
     */
    @Override
    public String getMessage() {
        return "Votre réservoir a une capacité insuffisante pour mettre " + litres + "L d'essence";
    }
}
